/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.impl.TestDAO;
import com.quantumdata.sct.dao.impl.TestResultsDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.GenericStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class TestResultsPanel
extends ActivityCardItemPanel {
    private TestResultVO testResultVO;
    private TestVO testVO;
    private JLabel testStatusL;
    private JTable table;
    private boolean printable = false;
    private StepResultTableModel tableModel;

    public TestResultsPanel(TestResultVO testResultVO) {
        this.testResultVO = testResultVO;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 300));
        try {
            TestDAO testDAO = (TestDAO)XMLDAOFactory.getTestDAO();
            this.testVO = (TestVO)testDAO.read(testResultVO.getCapabilityId());
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TestResultsPanel(TestResultVO testResultVO, TestVO testVO) {
        this.setLayout(new BorderLayout());
        this.testResultVO = testResultVO;
        this.testVO = testVO;
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(500, 200));
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void preShow() {
        Object object;
        try {
            object = (TestResultsDAO)XMLDAOFactory.getTestResultsDAO(SCTConstants.getUnitStorage(SCTSelection.instance().getUnitID()));
            this.testResultVO = ((TestResultsVO)((AbstractXMLStorageDAO)object).read(SCTSelection.instance().getUnitID())).getTestStepResults(this.testResultVO.getCapabilityId());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tableModel.fireTableDataChanged();
        object = this.testVO.getComplainceSectionId() + ": " + this.testResultVO.getStatus();
        if (this.testResultVO.getStatus() != null) {
            if (this.testResultVO.getStatus().equalsIgnoreCase("PASS")) {
                Color color = new Color(0, 180, 0);
                this.testStatusL.setForeground(color);
            } else {
                this.testStatusL.setForeground(Color.red);
            }
        }
        this.testStatusL.setText((String)object);
        this.updateUI();
    }

    private void init() throws Exception {
        Serializable serializable;
        String string = this.testVO.getComplainceSectionId() + ": " + this.testResultVO.getStatus();
        if (this.printable) {
            this.testStatusL = new JLabel(string);
        } else {
            this.testStatusL = new SCTLabel(string);
            this.testStatusL.setFont(SCTConstants.SS_B_12);
        }
        if (this.testResultVO.getStatus() != null) {
            if (this.testResultVO.getStatus().equalsIgnoreCase("PASS")) {
                serializable = new Color(0, 180, 0);
                this.testStatusL.setForeground((Color)serializable);
            } else {
                this.testStatusL.setForeground(Color.red);
            }
        }
        this.add((Component)this.testStatusL, "North");
        this.tableModel = new StepResultTableModel(this.testVO);
        this.table = new JTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(400);
        if (!this.printable) {
            this.table.setFont(SCTConstants.TR_B_12);
        }
        serializable = new Dimension(500, 300);
        this.table.setSize((Dimension)serializable);
        this.table.setPreferredSize((Dimension)serializable);
        this.table.setAutoResizeMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.white);
        this.add((Component)jScrollPane, "Center");
    }

    class StepResultTableModel
    extends DefaultTableModel {
        private Vector steps = new Vector();

        StepResultTableModel(TestVO testVO) throws Exception {
            AbstractStepVO[] abstractStepVOArray = testVO.getStepsVO();
            for (int i = 0; i < abstractStepVOArray.length; ++i) {
                if (abstractStepVOArray[i] instanceof CompositeStepVO) {
                    for (AbstractStepVO abstractStepVO : ((CompositeStepVO)abstractStepVOArray[i]).getChildStepsList()) {
                        if (abstractStepVO instanceof GenericStepVO) continue;
                        this.steps.add(abstractStepVO);
                    }
                    continue;
                }
                if (abstractStepVOArray[i] instanceof GenericStepVO) continue;
                this.steps.add(abstractStepVOArray[i]);
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.steps != null) {
                return this.steps.size();
            }
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            AbstractStepVO abstractStepVO = (AbstractStepVO)this.steps.get(n);
            TestStepResultVO testStepResultVO = TestResultsPanel.this.testResultVO.getTestStepResults(abstractStepVO.getId().toString());
            switch (n2) {
                case 0: {
                    if (abstractStepVO.getType() != 3) {
                        return abstractStepVO.getDescription();
                    }
                    String string = abstractStepVO.getDescription();
                    Object[] objectArray = testStepResultVO.getParameters().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        string = string + " " + ((ParameterVO)objectArray[i]).getValue();
                    }
                    return string;
                }
                case 1: {
                    if (testStepResultVO != null) {
                        String string = testStepResultVO.getStatus();
                        return string;
                    }
                    return "Undefined";
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Description";
                }
                case 1: {
                    return "Status";
                }
            }
            return "Undefined";
        }
    }
}

